/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPCRI_H
#define QKNXNETIPCRI_H

#include <QtKnx/qknxaddress.h>
#include <QtKnx/qtknxglobal.h>
#include <QtKnx/qknxnetipstruct.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxNetIpCriProxy final
{
public:
    QKnxNetIpCriProxy() = delete;
    ~QKnxNetIpCriProxy() = default;

    QKnxNetIpCriProxy(const QKnxNetIpCri &&) = delete;
    explicit QKnxNetIpCriProxy(const QKnxNetIpCri &cri);

    bool isValid() const;
    bool isExtended() const;

    QKnxNetIp::ConnectionType connectionType() const;
    QKnxNetIp::TunnelLayer tunnelLayer() const;
    QKnxAddress individualAddress() const;
    QKnxByteArray additionalData() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setConnectionType(QKnxNetIp::ConnectionType type);
        Builder &setTunnelLayer(QKnxNetIp::TunnelLayer layer);
        Builder &setIndividualAddress(const QKnxAddress &address);
        Builder &setAdditionalData(const QKnxByteArray &additionalData);

        QKnxNetIpCri create() const;

    private:
        QKnxNetIp::ConnectionType m_cType = QKnxNetIp::ConnectionType::Tunnel;
        QKnxByteArray m_additionalData;
    };
    static QKnxNetIpCriProxy::Builder builder();

private:
    const QKnxNetIpCri &m_cri;
};

QT_END_NAMESPACE

#endif
